<?php $__env->startSection('title','CARRISOFT V2: BON DE COMMANDE'); ?>


<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
        <h3 class="ml-5"><?php echo e(__('messages.HISTORIQUE DES RECEPTIONS')); ?></h3>
        <div class="col-12 col-sm-12 col-md-12">
            <div class="col-12 col-md-4 float-left">
                <a href="<?php echo e(route('rec.index')); ?>" class="btn btn-success"><i class="fa fa-plus"></i><?php echo e(__('messages.Nouvelle Reception')); ?></a>
            </div>
            <div class="col-12 col-sm-6 col-md-4 float-left">
                <a href="<?php echo e(route('rec.histo')); ?>" class="btn btn-danger"><i class="fa fa-info"></i><?php echo e(__('messages.Historique des receptions')); ?></a>
            </div>
            <div class="col-12 col-sm-6 col-md-4 float-right">
                <a href="<?php echo e(route('cmde.index')); ?>" class="btn btn-warning"><i class="fa fa-check"></i> <?php echo e(__('messages.Nouvelle Commande')); ?></a>
            </div>
        </div>

        <div class="info-box mb-1">
            <div class="row input-daterange">
                <div class="col-12 col-md-3">
                    <input type="text" name="from_date" id="from_date" class="form-control" placeholder="<?php echo e(__('messages.Date Debut')); ?>" readonly />
                </div>
                <div class="col-12 col-md-3">
                    <input type="text" name="to_date" id="to_date" class="form-control" placeholder="<?php echo e(__('messages.Date Fin')); ?>" readonly />
                </div>

                <div class="col-12 col-md-6">
                    <button type="button" name="filter" id="filter" class="btn btn-primary"><?php echo e(__('messages.Rechercher')); ?></button>
                    <button type="button" name="refresh" id="reset" class="btn btn-danger"><?php echo e(__('messages.Actualiser')); ?></button>
                </div>
            </div>
            <!-- /.info-box-content -->
        </div>

        <div class="col-md-12">
            <div class="info-box">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="histo_prod">
                        <thead>
                        <tr class="cart_menu" style="background-color: #00b0e8">
                            <td class="description">Date </td>
                            <td class="price"><?php echo e(__('messages.Commande')); ?></td>
                            <td class="price"><?php echo e(__('messages.Magasin')); ?></td>
                            <td class="total"><?php echo e(__('messages.Utilisateur')); ?></td>
                            <td><?php echo e(__('messages.Editer')); ?></td>
                            <td><?php echo e(__('messages.Imprimer')); ?></td>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>



    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        $(document).ready(function(){
            $('.input-daterange').datepicker({
                todayBtn:'linked',
                format:'yyyy-mm-dd',
                autoclose:true
            });

            load_data();

            function load_data(from_date = '', to_date = '')
            {
                $('#histo_prod').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url:'<?php echo e(route("rec.histo")); ?>',
                        data:{from_date:from_date, to_date:to_date}
                    },
                    columns: [
                        {
                            data:'date_reception',
                            name:'date_reception'
                        },
                        {
                            data:'code',
                            name:'code',
                            render:function (data, type, row) {
                                return "<a href='cmde/"+row.commande_id+"'>"+row.code+"</a>"}
                        },
                        {
                            data:'libelle',
                            name:'libelle'
                        },
                        {
                            data:'name',
                            name:'name'
                        },
                        {
                            data:'reception_id',
                            name:'reception_id',
                            render:function (data, type, row) {
                                return "<a href='#' class='btn btn-success'><i class='fa fa-edit'></i></a>"}
                        },
                        {
                            data:'reception_id',
                            name:'reception_id',
                            render:function (data, type, row) {
                                return "<a href='rec/"+row.reception_id+"' class='btn btn-info'><i class='fa fa-print'></i></a>"}
                        }

                    ]
                });
            }

            $('#filter').click(function(){
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                if(from_date != '' && to_date != '')
                {
                    $('#histo_prod').DataTable().destroy();
                    load_data(from_date, to_date);
                }
                else
                {
                    alert('<?php echo e(__('messages.Selectionner la periode')); ?>');
                }
            });

            $('#reset').click(function(){
                $('#from_date').val('');
                $('#to_date').val('');
                $('#histo_prod').DataTable().destroy();
                load_data();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/reception/histo.blade.php ENDPATH**/ ?>